/*
 * Decompiled with CFR 0.152.
 */
package club.sk1er.patcher.util.screenshot;

import club.sk1er.mods.core.universal.ChatColor;
import club.sk1er.mods.core.util.ModCoreDesktop;
import club.sk1er.mods.core.util.Multithreading;
import club.sk1er.patcher.Patcher;
import club.sk1er.patcher.command.UploadScreenshotTask;
import club.sk1er.patcher.config.PatcherConfig;
import club.sk1er.patcher.util.chat.ChatUtilities;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.jetbrains.annotations.NotNull;

public class AsyncScreenshots
implements Runnable {
    private final int width;
    private final int height;
    private final int[] pixelValues;
    private final Minecraft mc = Minecraft.func_71410_x();
    private final File screenshotDirectory;
    private final Framebuffer framebuffer;
    private static BufferedImage image;
    private static File screenshot;
    public static final String prefix;

    public AsyncScreenshots(int width, int height, int[] pixelValues, Framebuffer framebuffer, File screenshotDirectory) {
        this.width = width;
        this.height = height;
        this.pixelValues = pixelValues;
        this.framebuffer = framebuffer;
        this.screenshotDirectory = screenshotDirectory;
    }

    @Override
    public void run() {
        this.processPixelValues(this.pixelValues, this.width, this.height);
        screenshot = AsyncScreenshots.getTimestampedPNGFileForDirectory(this.screenshotDirectory);
        try {
            if (OpenGlHelper.func_148822_b()) {
                int tHeight;
                image = new BufferedImage(this.framebuffer.field_147621_c, this.framebuffer.field_147618_d, 1);
                int heightSize = tHeight = this.framebuffer.field_147620_b - this.framebuffer.field_147618_d;
                while (tHeight < this.framebuffer.field_147620_b) {
                    for (int widthSize = 0; widthSize < this.framebuffer.field_147621_c; ++widthSize) {
                        image.setRGB(widthSize, tHeight - heightSize, this.pixelValues[tHeight * this.framebuffer.field_147622_a + widthSize]);
                    }
                    ++tHeight;
                }
            } else {
                image = new BufferedImage(this.width, this.height, 1);
                image.setRGB(0, 0, this.width, this.height, this.pixelValues, 0, this.width);
            }
            ImageIO.write((RenderedImage)image, "png", screenshot);
            if (!PatcherConfig.screenshotNoFeedback) {
                this.sendChatMessages(screenshot);
            }
            if (PatcherConfig.screenshotPreview) {
                Patcher.instance.getViewer().newCapture(image);
            }
            if (PatcherConfig.autoCopyScreenshot) {
                CopyScreenshot.copyScreenshot(this.mc.field_71439_g != null);
            }
        }
        catch (Exception e) {
            ChatUtilities.sendMessage("Failed to capture screenshot. " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void sendChatMessages(File screenshot) throws IOException {
        boolean compact = PatcherConfig.compactScreenshotResponse;
        ChatComponentText chatComponent = !compact ? new ChatComponentText(prefix + "Screenshot saved to " + screenshot.getName() + " (" + screenshot.length() / 1024L + "kb)") : new ChatComponentText(prefix + "Screenshot saved.");
        chatComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$openfolder"));
        chatComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7Open this screenshot."))));
        ChatComponentText favoriteComponent = new ChatComponentText(ChatColor.YELLOW.toString() + ChatColor.BOLD + (compact ? "FAV" : "FAVORITE"));
        favoriteComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$favorite"));
        favoriteComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7This will save the screenshot to a new folder called\n&afavorite_screenshots &7in your Minecraft directory.\n&cThis cannot be done once a new screenshot is taken."))));
        ChatComponentText deleteComponent = new ChatComponentText(ChatColor.RED.toString() + ChatColor.BOLD + (compact ? "DEL" : "DELETE"));
        deleteComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$delete"));
        deleteComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7This will delete the screenshot from your screenshots folder.\n&cThis is not recoverable and cannot be deleted once a\n&cnew screenshot is taken or made favorite."))));
        ChatComponentText imgurComponent = new ChatComponentText(ChatColor.GREEN.toString() + ChatColor.BOLD + (compact ? "UPL" : "UPLOAD"));
        imgurComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$upload"));
        imgurComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7Upload the screenshot to Imgur, an image hosting website.\n&cThis cannot be uploaded once a new screenshot\n&cis taken, made favorite, or deleted."))));
        ChatComponentText copyComponent = new ChatComponentText(ChatColor.AQUA.toString() + ChatColor.BOLD + (compact ? "CPY" : "COPY"));
        copyComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/$copyss"));
        copyComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7Copy this image to your system clipboard.\n&cThis cannot be copied once a new screenshot\n&cis taken, made favorite, or deleted."))));
        ChatComponentText folderComponent = new ChatComponentText(ChatColor.BLUE.toString() + ChatColor.BOLD + (compact ? "DIR" : "FOLDER"));
        folderComponent.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.screenshotDirectory.getCanonicalPath()));
        folderComponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(this.colorMessage("&7Open your screenshots folder."))));
        ChatComponentText controlsMessage = new ChatComponentText("");
        controlsMessage.func_150257_a((IChatComponent)favoriteComponent).func_150258_a(" ").func_150257_a((IChatComponent)deleteComponent).func_150258_a(" ").func_150257_a((IChatComponent)imgurComponent).func_150258_a(" ").func_150257_a((IChatComponent)copyComponent).func_150258_a(" ").func_150257_a((IChatComponent)folderComponent);
        GuiNewChat chat = this.mc.field_71456_v.func_146158_b();
        chat.func_146227_a((IChatComponent)chatComponent);
        chat.func_146234_a((IChatComponent)controlsMessage, 32251);
    }

    private void processPixelValues(int[] pixels, int displayWidth, int displayHeight) {
        int[] xValues = new int[displayWidth];
        int yValues = displayHeight / 2;
        for (int val = 0; val < yValues; ++val) {
            System.arraycopy(pixels, val * displayWidth, xValues, 0, displayWidth);
            System.arraycopy(pixels, (displayHeight - 1 - val) * displayWidth, pixels, val * displayWidth, displayWidth);
            System.arraycopy(xValues, 0, pixels, (displayHeight - 1 - val) * displayWidth, displayWidth);
        }
    }

    private static File getTimestampedPNGFileForDirectory(File gameDirectory) {
        File screenshot;
        String dateFormatting = new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
        int screenshotCount = 1;
        while ((screenshot = new File(gameDirectory, dateFormatting + (screenshotCount == 1 ? "" : "_" + screenshotCount) + ".png")).exists()) {
            ++screenshotCount;
        }
        return screenshot;
    }

    private String colorMessage(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    static {
        prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)"&e[Patcher] &r");
    }

    static class ImageSelection
    implements Transferable {
        private final Image image;

        ImageSelection(Image image) {
            this.image = image;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{DataFlavor.imageFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return DataFlavor.imageFlavor == flavor;
        }

        @Override
        @NotNull
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (DataFlavor.imageFlavor != flavor) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.image;
        }
    }

    public static class CopyScreenshot
    extends CommandBase {
        public String func_71517_b() {
            return "$copyss";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/$copyss";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            try {
                CopyScreenshot.copyScreenshot(true);
            }
            catch (Exception e) {
                ChatUtilities.sendMessage("&cFailed to copy screenshot to clipboard.", false);
                e.printStackTrace();
            }
        }

        public int func_82362_a() {
            return -1;
        }

        public static void copyScreenshot(boolean message) {
            ImageSelection sel = new ImageSelection(image);
            Multithreading.runAsync(() -> {
                block3: {
                    try {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(sel, null);
                        if (message) {
                            ChatUtilities.sendMessage("&aScreenshot has been copied to your clipboard.", false);
                        }
                    }
                    catch (Exception e) {
                        if (!message) break block3;
                        ChatUtilities.sendMessage("&cFailed to copy screenshot to clipboard.", false);
                    }
                }
            });
        }
    }

    public static class UploadScreenshot
    extends CommandBase {
        public String func_71517_b() {
            return "$upload";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/$upload";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            UploadScreenshotTask.INSTANCE.execute(screenshot);
        }

        public int func_82362_a() {
            return -1;
        }
    }

    public static class DeleteScreenshot
    extends CommandBase {
        public String func_71517_b() {
            return "$delete";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/$delete";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            try {
                if (screenshot.exists()) {
                    ChatUtilities.sendMessage("&c" + screenshot.getName() + " has been deleted.");
                    screenshot.delete();
                    screenshot = null;
                } else {
                    ChatUtilities.sendMessage("&cCouldn't find " + screenshot.getName());
                }
            }
            catch (NullPointerException e) {
                ChatUtilities.sendMessage("&cFailed to delete screenshot, maybe the file was moved/deleted?");
            }
        }

        public int func_82362_a() {
            return -1;
        }
    }

    public static class FavoriteScreenshot
    extends CommandBase {
        public String func_71517_b() {
            return "$favorite";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/$favorite";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            try {
                File favoritedScreenshots = AsyncScreenshots.getTimestampedPNGFileForDirectory(new File("./favorite_screenshots"));
                screenshot.delete();
                if (!favoritedScreenshots.exists()) {
                    favoritedScreenshots.mkdirs();
                }
                ImageIO.write((RenderedImage)image, "png", favoritedScreenshots);
                ChatUtilities.sendMessage("&e" + screenshot.getName() + " has been favorited.");
            }
            catch (Throwable e) {
                ChatUtilities.sendMessage("&cFailed to favorite screenshot, maybe the file was moved/deleted?");
            }
        }

        public int func_82362_a() {
            return -1;
        }
    }

    public static class ScreenshotsFolder
    extends CommandBase {
        public String func_71517_b() {
            return "$openfolder";
        }

        public String func_71518_a(ICommandSender sender) {
            return "/$openfolder";
        }

        public void func_71515_b(ICommandSender sender, String[] args) {
            try {
                ModCoreDesktop.INSTANCE.open(new File("./screenshots"));
            }
            catch (Exception e) {
                ChatUtilities.sendMessage("Unfortunately, we were unable to open the screenshots folder. Please report this to us at https://discord.gg/sk1er.");
            }
        }

        public int func_82362_a() {
            return -1;
        }
    }
}

